USE master
IF DB_ID('TVPTests') IS NOT NULL
BEGIN
	ALTER DATABASE TVPTests SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
	DROP DATABASE TVPTests;
END

CREATE DATABASE TVPTests
GO
USE TVPTests
GO
BEGIN TRANSACTION
DROP PROCEDURE IF EXISTS dbo.CheckFillDates

GO
DROP TYPE IF EXISTS PharmacyData;
GO
CREATE TYPE PharmacyData 
AS TABLE
(	
	Dosage INT,
	Drug VARCHAR(20),
	FirstName VARCHAR(50),
	LastName VARCHAR(50),
	AddressLine1 VARCHAR(250),
	PhoneNumber VARCHAR(50),
	CellNumber VARCHAR(50),
	EmailAddress VARCHAR(100),
	FillDate DATETIME
)
GO
CREATE PROCEDURE dbo.CheckFillDates
(@Data [dbo].[PharmacyData] READONLY)
AS 
BEGIN 
DECLARE @FilteredResult [dbo].[PharmacyData]
INSERT INTO @FilteredResult
SELECT *
FROM @Data

IF (
SELECT COUNT(*) 
FROM @FilteredResult) < (SELECT COUNT(*) 
FROM @Data)
BEGIN
	SELECT *
	FROM @FilteredResult
END 
ELSE 
	SELECT *
	FROM @FilteredResult 
	UNION SELECT * 
	FROM @Data
END
GO

COMMIT